/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

#ifndef MX_NTDDK_H
#define MX_NTDDK_H

#define htons(x) RtlUshortByteSwap(x)
#define ntohs(x) RtlUshortByteSwap(x)
#define htonl(x) RtlUlongByteSwap(x)
#define ntohl(x) RtlUlongByteSwap(x)
#define mx_hton_u64(x) \
((((x) >> 56) &       0xff) + \
 (((x) >> 40) &     0xff00) + \
 (((x) >> 24) &   0xff0000) + \
 (((x) >> 8)  & 0xff000000) + \
 (((x) & 0xff000000) <<  8) + \
 (((x) &   0xff0000) << 24) + \
 (((x) &     0xff00) << 40) + \
 (((x) &       0xff) << 56))
#define mx_ntoh_u64(x) mx_hton_u64(x)

typedef struct mx_instance_state mx_instance_state_t;
typedef struct mx_page_pin mx_page_pin_t;

struct mx_page_pin
{
  mcp_dma_addr_t dma;
  uint64_t va;
  PMDL mdl;
};

void mx_init_sem(KSEMAPHORE* sem);
int mx_can_be_privileged(PIRP irp);
int mx_frob_chipsets(ULONG my_bus_number);
int mx_frob_pcie_link(ULONG my_bus_number);

#endif
